﻿<?xml version="1.0" encoding="utf-8"?>
<pattern id="Content" xmlns="http://purl.oclc.org/dsdl/schematron">
    <title>Content Validations</title>

    <rule context="xbrli:xbrl/orgname1.02.00:OrganisationNameDetails">
        <let name="thisContextId" value="./*[1]/@contextRef" />

        <!-- Rule ID: VR.SS.GEN.000007
        
        WHERE IN TUPLE(orgname1.02.00:OrganisationNameDetails)
        IF (OrganisationNameDetails.OrganisationalNameType.Code <> "MN")
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000007" diagnostics="DVR.SS.GEN.000007"
            test="not(
                pyde.02.00:OrganisationNameDetails.OrganisationalNameType.Code[not(@i:nil = 'true') and not(. = 'MN')]
            )" />
      
    </rule>

    <rule context="xbrli:xbrl/email1.02.00:ElectronicContactElectronicMail">
        <let name="thisContextId" value="./*[1]/@contextRef" />

        <!-- Rule ID: VR.SS.GEN.000014
        
        WHERE IN TUPLE(email1.02.00:ElectronicContactElectronicMail)
        IF (ElectronicContact.ElectronicMail.Usage.Code <>"03")
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000014" diagnostics="DVR.SS.GEN.000014"
            test="not(
                pyde.02.00:ElectronicContact.ElectronicMail.Usage.Code[not(@i:nil = 'true') and not(. = '03')]
            )" />
      
    </rule>

    <rule context="xbrli:xbrl/phone1.02.00:ElectronicContactTelephone">
        <let name="thisContextId" value="./*[1]/@contextRef" />

        <!-- Rule ID: VR.SS.GEN.000018
        
        WHERE IN TUPLE(phone1.02.00:ElectronicContactTelephone)
        IF (ElectronicContact.Telephone.Usage.Code <>"03")
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000018" diagnostics="DVR.SS.GEN.000018"
            test="not(
                pyde.02.00:ElectronicContact.Telephone.Usage.Code[not(@i:nil = 'true') and not(. = '03')]
            )" />

        <!-- Rule ID: VR.SS.GEN.000021
        
        WHERE IN TUPLE(phone1.02.00:ElectronicContactTelephone)
        IF (ElectronicContact.Telephone.ServiceLine.Code NOT IN SET ("01", "02"))
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000021" diagnostics="DVR.SS.GEN.000021"
            test="not(
                pyde.02.00:ElectronicContact.Telephone.ServiceLine.Code[not(@i:nil = 'true') and not(matches(., '^(01|02)$'))]
            )" />
      
    </rule>

    <rule context="xbrli:xbrl/address3.02.01:AddressDetails">
        <let name="thisContextId" value="./*[1]/@contextRef" />

        <!-- Rule ID: VR.SS.GEN.000027
        
        WHERE IN TUPLE (address3.02.01:AddressDetails)
        IF (AddressDetails.Usage.Code <>"POS" or "RES")
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000027" diagnostics="DVR.SS.GEN.000027"
            test="not(
                pyde.02.01:AddressDetails.Usage.Code[not(@i:nil = 'true') and not(matches(., '^(POS|RES)$'))]
            )" />

        <!-- Rule ID: VR.SS.GEN.000030
        
        WHERE IN TUPLE (address3.02.01:AddressDetails)
        IF (AddressDetails.Country.Code = "au") AND (AddressDetails.Postcode.Text = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000030" diagnostics="DVR.SS.GEN.000030"
            test="not(
                pyde.02.08:AddressDetails.Country.Code[. = 'au']
                and
                not(pyde.02.00:AddressDetails.Postcode.Text[not(@i:nil = 'true')])
            )" />

        <!-- Rule ID: VR.SS.GEN.000031
        
        WHERE IN TUPLE (address3.02.01:AddressDetails)
        IF (AddressDetails.Country.Code = "au") AND (AddressDetails.StateOrTerritory.Code = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000031" diagnostics="DVR.SS.GEN.000031"
            test="not(
                pyde.02.08:AddressDetails.Country.Code[. = 'au']
                and
                not(pyde.02.00:AddressDetails.StateOrTerritory.Code[not(@i:nil = 'true')])
            )" />

        <!-- Rule ID: VR.SS.GEN.000038
        
        WHERE IN TUPLE (address3.02.01:AddressDetails)
        IF LENGTH(AddressDetails.LocalityName.Text) > 50
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000038" diagnostics="DVR.SS.GEN.000038"
            test="not(
                pyde.02.00:AddressDetails.LocalityName.Text[string-length(.) &gt; 50]
            )" />
      
    </rule>

    <rule context="xbrli:xbrl">
      
        <!-- Rule ID: VR.SS.CMR.000008
        
        IF COUNT(RP.SENDER:orgname1.02.00:OrganisationNameDetails) > 1
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CMR.000008" diagnostics="DVR.SS.CMR.000008"
            test="not(
                count(key('contextDetailsById', $RP.MessageSender.ContextId)[self::orgname1.02.00:OrganisationNameDetails]) &gt; 1
            )" />

        <!-- Rule ID: VR.SS.CMR.000010
        
        IF COUNT(RP.SENDER:prsnstrcnm1.02.00:PersonNameDetails) > 1
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CMR.000010" diagnostics="DVR.SS.CMR.000010"
            test="not(
                count(key('contextDetailsById', $RP.MessageSender.ContextId)[self::prsnstrcnm1.02.00:PersonNameDetails]) &gt; 1
            )" />

        <!-- Rule ID: VR.SS.CMR.000012
        
        IF COUNT(RP.SENDER:email1.02.00:ElectronicContactElectronicMail) > 1
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CMR.000012" diagnostics="DVR.SS.CMR.000012"
            test="not(
                count(key('contextDetailsById', $RP.MessageSender.ContextId)[self::email1.02.00:ElectronicContactElectronicMail]) &gt; 1
            )" />

        <!-- Rule ID: VR.SS.CMR.000014
        
        IF COUNT(RP.SENDER:phone1.02.00:ElectronicContactTelephone) > 1
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CMR.000014" diagnostics="DVR.SS.CMR.000014"
            test="not(
                count(key('contextDetailsById', $RP.MessageSender.ContextId)[self::phone1.02.00:ElectronicContactTelephone]) &gt; 1
            )" />
        
        <!-- Rule ID: VR.SS.CMR.000016
        
        IF COUNT(RP.RECEIVER:orgname1.02.00:OrganisationNameDetails) > 1
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CMR.000016" diagnostics="DVR.SS.CMR.000016"
            test="not(
                count(key('contextDetailsById', $RP.MessageReceiver.ContextId)[self::orgname1.02.00:OrganisationNameDetails]) &gt; 1
            )" />
  
        <!-- Rule ID: VR.SS.CMR.000018
        
        IF COUNT(RP.EMPLOYER:orgname1.02.00:OrganisationNameDetails) > 1
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CMR.000018" diagnostics="DVR.SS.CMR.000018"
            test="not(
                count(key('contextDetailsById', $RP.Employer.ContextId)[self::orgname1.02.00:OrganisationNameDetails]) &gt; 1
            )" />

    </rule>

    <rule context="xbrli:xbrl/xbrli:context[generate-id() = $RP.SuperFundMember.Context/generate-id()]">
        <let name="thisContextId" value="@id" />

        <!-- Rule ID: VR.SS.CMR.000020
        
        FOR ANY OCCURRENCE OF CONTEXT (RP.SUPERFUNDMEMBER)
        IF COUNT(RP.SUPERFUNDMEMBER:prsnstrcnm3.02.01:PersonNameDetails) > 1
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CMR.000020" diagnostics="DVR.SS.CMR.000020"
            test="not(
                count(key('contextDetailsById', $thisContextId)[self::prsnstrcnm3.02.01:PersonNameDetails]) &gt; 1
            )" />

        <!-- Rule ID: VR.SS.CMR.000021
        
        FOR ANY OCCURRENCE OF CONTEXT (RP.SUPERFUNDMEMBER)
        IF RP.SUPERFUNDMEMBER:prsnstrcnm3.02.01:PersonNameDetails/pyde.02.00:PersonNameDetails.PersonNameType.Code <> "LGL"
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CMR.000021" diagnostics="DVR.SS.CMR.000021"
            test="not(
                key('contextDetailsById', $thisContextId)[self::prsnstrcnm3.02.01:PersonNameDetails]/pyde.02.00:PersonNameDetails.PersonNameType.Code[not(@i:nil = 'true') and not(. = 'LGL')]
            )" />

        <!-- Rule ID: VR.SS.CMR.000022
        
        FOR ANY OCCURRENCE OF CONTEXT (RP.SUPERFUNDMEMBER)
        IF RP.SUPERFUNDMEMBER:prsnstrcnm3.02.01:PersonNameDetails/pyde.02.05:PersonNameDetails.Usage.Code <> "Contact"
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CMR.000022" diagnostics="DVR.SS.CMR.000022"
            test="not(
                key('contextDetailsById', $thisContextId)[self::prsnstrcnm3.02.01:PersonNameDetails]/pyde.02.05:PersonNameDetails.Usage.Code[not(@i:nil = 'true') and not(. = 'Contact')]
            )" />

        <!-- Rule ID: VR.SS.CMR.000023
        
        FOR ANY OCCURRENCE OF CONTEXT (RP.SUPERFUNDMEMBER)
        IF RP.SUPERFUNDMEMBER:prsnstrcnm3.02.01:PersonNameDetails/pyde.02.00:PersonNameDetails.Currency.Code <> "C"
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CMR.000023" diagnostics="DVR.SS.CMR.000023"
            test="not(
                key('contextDetailsById', $thisContextId)[self::prsnstrcnm3.02.01:PersonNameDetails]/pyde.02.00:PersonNameDetails.Currency.Code[not(@i:nil = 'true') and not(. = 'C')]
            )" />

        <!-- Rule ID: VR.SS.CMR.000027
        
        FOR ANY OCCURRENCE OF CONTEXT (RP.SUPERFUNDMEMBER)
        IF COUNT(RP.SUPERFUNDMEMBER:address3.02.01:AddressDetails) > 1
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CMR.000027" diagnostics="DVR.SS.CMR.000027"
            test="not(
                count(key('contextDetailsById', $thisContextId)[self::address3.02.01:AddressDetails]) &gt; 1
            )" />

        <!-- Rule ID: VR.SS.CMR.000028
        
        FOR ANY OCCURRENCE OF CONTEXT (RP.SUPERFUNDMEMBER)
        IF COUNT(RP.SUPERFUNDMEMBER:email1.02.00:ElectronicContactElectronicMail) > 1
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CMR.000028" diagnostics="DVR.SS.CMR.000028"
            test="not(
                count(key('contextDetailsById', $thisContextId)[self::email1.02.00:ElectronicContactElectronicMail]) &gt; 1
            )" />

        <!-- Rule ID: VR.SS.CMR.000029
        
        FOR ANY OCCURRENCE OF CONTEXT (RP.SUPERFUNDMEMBER)
        IF COUNT(RP.SUPERFUNDMEMBER:phone1.02.00:ElectronicContactTelephone) > 2
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CMR.000029" diagnostics="DVR.SS.CMR.000029"
            test="not(
                count(key('contextDetailsById', $thisContextId)[self::phone1.02.00:ElectronicContactTelephone]) &gt; 2
            )" />

        <!-- Rule ID: VR.SS.CMR.000033
        
        FOR ANY OCCURRENCE OF CONTEXT (RP.SUPERFUNDMEMBER)
        IF (RP.SUPERFUNDMEMBER:Identifiers.TaxFileNumberNotProvided.Indicator = FALSE
          and RP.SUPERFUNDMEMBER Identifier Scheme = "http://www.sbr.gov.au/id")
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CMR.000033" diagnostics="DVR.SS.CMR.000033"
            test="not(
                key('contextDetailsById', $thisContextId)[self::pyid.02.05:Identifiers.TaxFileNumberNotProvided.Indicator[. = 'false']]
                and
                xbrli:entity/xbrli:identifier[matches(@scheme, '^http://www.sbr.gov.au/id$')]
            )" />

        <!-- Rule ID: VR.SS.CMR.000034
        
        FOR ANY OCCURRENCE OF CONTEXT (RP.SUPERFUNDMEMBER)
        IF (RP.SUPERFUNDMEMBER:Identifiers.TaxFileNumberNotProvided.Indicator = TRUE AND RP.SUPERFUNDMEMBER Identifier Scheme = "http://www.ato.gov.au/tfn")
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CMR.000034" diagnostics="DVR.SS.CMR.000034"
            test="not(
                key('contextDetailsById', $thisContextId)[self::pyid.02.05:Identifiers.TaxFileNumberNotProvided.Indicator[. = 'true']]
                and
                xbrli:entity/xbrli:identifier[matches(@scheme, '^http://www.ato.gov.au/tfn$')]
            )" />
      
    </rule>
</pattern>